local assets =
{
    Asset("ANIM", "anim/gene.zip"),
	Asset("ATLAS", "images/inventoryimages/gene_dikang.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_duxing.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_faguang.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_fushi.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_guangxue.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_guge.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_kunchong.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_luoxuan.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_mianyi.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_minjie.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_nengliang.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_shuisu.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_xukong.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_yelvsu.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_zaisheng.xml"),
	Asset("ATLAS", "images/inventoryimages/gene_zishiying.xml"),
	
}

local function buildgene(lei)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("gene")
    inst.AnimState:SetBuild("gene")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "gene"..lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gene"..lei..".xml"
    inst:AddComponent("selfstacker")
    inst:AddTag("gene")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("gene"..lei, fn, assets)
end
return 
    buildgene("_dikang"),
	buildgene("_duxing"),
	buildgene("_faguang"),
	buildgene("_fushi"),
	buildgene("_guangxue"),
	buildgene("_guge"),
	buildgene("_kunchong"),
	buildgene("_luoxuan"),
	buildgene("_mianyi"),
	buildgene("_minjie"),
	buildgene("_nengliang"),
    buildgene("_shuisu"),
    buildgene("_xukong"),
    buildgene("_yelvsu"),
	buildgene("_zaisheng"),
    buildgene("_zishiying",true)